-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

--- Demontage Demodaten
SET SESSION AUTHORIZATION 'DEMODATA';

DO $$
 DECLARE
   _ak_nr_2021               varchar   := 'G.PKW.A-1168534 /A /2021';
   _ak_nr_2022A              varchar   := 'G.PKW.A-1168534 /A /2022A';
   _ak_nr_2022B              varchar   := 'G.PKW.A-1168534 /A /2022B';
   _ak_ac                    varchar   := 'PR1001';
   ---
   _ak_standard_mgc_2021     integer := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_ak_nr_2021);
   _ak_standard_mgc_2022A    integer := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_ak_nr_2022A);
   _ak_standard_mgc_2022B    integer := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_ak_nr_2022B);
   ---
   _artmgc__m_id             integer;
   ---
   _op_ix_2021_v1            integer;        --- 1007
   _op_ix_2021_v2            integer;        --- 1008
   _op_ix_2022A_v1           integer;        --- 1009
   _op_ix_2022A_v2           integer;        --- 1010
   _op_ix_2022B_v1           integer;        --- 1012
   _op_ix_2022B_v2           integer;        --- 1013
   ---
   _w_wen_ak_nr_2021_1       integer := 0;   --- 10031
   _w_wen_ak_nr_2021_2       integer := 0;   --- 10032
   _w_wen_ak_nr_2021_3       integer := 0;   --- 10033
   _w_wen_ak_nr_2022A        integer := 0;   --- 10058
   _w_wen_ak_nr_2022B        integer := 0;   --- 10059
   ---
   _q_nr_ak_nr_2021_1        integer := getnumcirclenr('qabser')::INTEGER;   --- 4200004
   _q_nr_ak_nr_2021_2        integer := getnumcirclenr('qabser')::INTEGER;   --- 4200005
   _q_nr_ak_nr_2021_3        integer := getnumcirclenr('qabser')::INTEGER;   --- 4200006
   ---
   ld_id_1                   integer;
   ld_id_2                   integer;
   ld_id_3                   integer;
   ---
   ab_ix_1                   integer;
   ab_ix_2                   integer;
   ab_ix_3                   integer;
   ---
   lg_id_ZL_2022A            integer;
   lg_id_ZL_2022B            integer;
   ---
   o2_id_2021_v2             integer;
   o2_id_2022A_v2            integer;
   o2_id_2022B_v2            integer;
   ---
   _ag_nr                    varchar := 'LA22-00110';
   _ag_id_pos_10             integer;
   _ag_id_pos_20             integer;
   _ag_id_pos_30             integer;
   _ag_id_pos_40             integer;
   _ag_id_pos_50             integer;
   ---
   _l_nr_ak_nr_2021_1        integer;
   _l_nr_ak_nr_2021_2        integer;
   _l_nr_ak_nr_2021_3        integer;
   ---
   _lgs_id                   integer;


 BEGIN
    --- ***** Stammdaten *****
    --- Artikel anlegen
    INSERT  INTO  art( ak_ac , ak_nr      , ak_bes, ak_bez                            , ak_bfr, ak_dim       , ak_lag, ak_los, ak_znr   , ak_nrhl                     , ak_pknr, ak_chnrreq, ak_verfueg, ak_vkprund, ak_sernrreq, ak_fertigung, ak_standard_mgc )
        VALUES       ( _ak_ac, _ak_nr_2021, 1     , 'Getriebe  PKW  -  Revision  2021', 1     , '550x600  mm', true  , 1     , '1168534', _ak_nr_2021, 1      , true      , 1         , 0.01      , true       , true        , 1               );

    INSERT  INTO  art( ak_ac , ak_nr       , ak_bez                             , ak_bfr, ak_dim      , ak_lag, ak_los, ak_tot, ak_znr   , ak_nrhl     , ak_pknr, ak_vkpbas, ak_verfueg, ak_vkprund, ak_sernrreq, ak_fertigung, ak_standard_mgc )
        VALUES       ( _ak_ac, _ak_nr_2022B, 'Getriebe  PKW  -  Revision  2022b', 1     , '550x600  mm', true , 1     , 1     , '1168534', _ak_nr_2022B, 1      , 1559.3949, 1         , 0.01      , true       , true        , 1               );

    INSERT  INTO  art( ak_ac , ak_nr       , ak_bez                             , ak_bfr, ak_dim       , ak_lag, ak_los, ak_tot, ak_znr   , ak_nrhl     , ak_pknr, ak_vkpbas, ak_chnrreq, ak_verfueg, ak_vkprund, ak_sernrreq, ak_fertigung, ak_standard_mgc )
        VALUES       ( _ak_ac, _ak_nr_2022A, 'Getriebe  PKW  -  Revision  2022a', 1     , '550x600  mm', true  , 1     , 1     , '1168534', _ak_nr_2022A, 1      , 1559.3949, true      , 1         , 0.01      , true       , true        , 1               );
    ---

    --- Lagerort anlegen
    INSERT  INTO  lagerorte( lgo_desc                  , lgo_name, lgo_werthg, lgo_beistell, lgo_nodelete, lgo_verfgbar )
       VALUES              ( 'Kunden  Beistelllagerort', 'BELO'  , false     , true        , true        , false        );
    ---

    --- AVOR
    INSERT  INTO  opl( op_n       , op_vi, op_agk, op_kalku, op_standard, op_qs_freigabe, op_mp_insert_by, op_mp_insert_date, op_mp_modified_by, op_mp_modified_date  )
        VALUES       ( _ak_nr_2021, 1  , 0     , true    , true       , false, 'DEMODATA', current_date, 'DEMO', current_date  )
    RETURNING op_ix INTO _op_ix_2021_v1;
    ---
    INSERT  INTO  opl( op_n       , op_vi, op_agk, op_kalku, op_standard, op_mp_insert_by, op_mp_insert_date, op_mp_modified_by, op_mp_modified_date, op_vit  )
        VALUES       ( _ak_nr_2021, 2  , 15    , false   , false      , 'DEMODATA', current_date, 'DEMO', current_date, 'Demontage' )
    RETURNING op_ix INTO _op_ix_2021_v2;
    ---
    INSERT  INTO  opl( op_n        , op_vi, op_agk, op_kalku, op_standard, op_qs_freigabe, op_mp_insert_by, op_mp_insert_date, op_mp_modified_by, op_mp_modified_date  )
        VALUES       ( _ak_nr_2022A, 1  , 0     , true    , true       , false, 'DEMODATA', current_date, 'DEMO', current_date  )
    RETURNING op_ix INTO _op_ix_2022A_v1;
    ---
    INSERT  INTO  opl( op_n        , op_vi, op_agk, op_kalku, op_standard, op_mp_insert_by, op_mp_insert_date, op_mp_modified_by, op_mp_modified_date, op_vit  )
        VALUES       ( _ak_nr_2022A, 2  , 15    , false   , false      , 'DEMODATA', current_date, 'DEMO', current_date, 'Upgrade  von  Revision  2021'  )
    RETURNING op_ix INTO _op_ix_2022A_v2;
    ---
    INSERT  INTO  opl( op_n        , op_vi, op_agk, op_kalku, op_standard, op_qs_freigabe, op_mp_insert_by, op_mp_insert_date, op_mp_modified_by, op_mp_modified_date  )
        VALUES       ( _ak_nr_2022B, 1  , 0     , true    , true       , false, 'DEMODATA', current_date, 'DEMO', current_date  )
    RETURNING op_ix INTO _op_ix_2022B_v1;
    ---
    INSERT  INTO  opl( op_n        , op_vi, op_agk, op_kalku, op_standard, op_mp_insert_by, op_mp_insert_date, op_mp_modified_by, op_mp_modified_date, op_vit  )
        VALUES       ( _ak_nr_2022B, 2  , 15    , false   , false      , 'DEMODATA', current_date, 'DEMO', current_date, 'Umbau  von  Revision  2021'  )
    RETURNING op_ix INTO _op_ix_2022B_v2;
    ---

    --- op2
    INSERT  INTO  op2( o2_n, o2_ix          , o2_ks    , o2_th, o2_tr, o2_txt   , o2_th_sek, o2_tr_sek, o2_lgz_sek, o2_zeinh_tr, o2_zeinh_tx )
        VALUES       ( 10  , _op_ix_2022B_v1, 'MON-001', 60   , 0.5  , 'Montage', 3600     , 1800     , 0         , 1          , 2           );
    ---
    INSERT  INTO  op2( o2_n, o2_ix          , o2_ks    , o2_th, o2_tv, o2_txt            , o2_th_sek, o2_lgz_sek, o2_zeinh_tr, o2_zeinh_tx )
        VALUES       ( 10  , _op_ix_2022A_v2, 'MON-001', 10   , 10   , 'Einbau  Dichtung', 600      , 0         , 1          , 2           )
        RETURNING o2_id INTO o2_id_2022A_v2;
    ---
    INSERT  INTO  op2( o2_n, o2_ix          , o2_ks    , o2_th, o2_tv, o2_txt                               , o2_th_sek, o2_lgz_sek, o2_zeinh_tr, o2_zeinh_tx )
        VALUES       ( 10  , _op_ix_2022B_v2, 'MON-001', 20   , 10   , 'Ausbau  Dichtsatz. Einbau  Dichtung', 1200     , 0         , 1          , 2           )
        RETURNING o2_id INTO o2_id_2022B_v2;
    ---
    INSERT  INTO  op2( o2_n, o2_ix         , o2_ks     , o2_th, o2_tr, o2_txt   , o2_th_sek, o2_tr_sek, o2_lgz_sek, o2_zeinh_tr, o2_zeinh_tx )
        VALUES       ( 10  , _op_ix_2021_v1, 'MON-001' , 60   , 0.5  , 'Montage', 3600     , 1800     , 0         , 1          , 2           );
    ---
    INSERT  INTO  op2( o2_n, o2_ix         , o2_ks     , o2_th, o2_tn, o2_tr, o2_txt                                        , o2_th_sek, o2_tn_sek, o2_tr_sek, o2_lgz_sek, o2_zeinh_tr, o2_zeinh_tx )
        VALUES       ( 20  , _op_ix_2021_v1, 'QS-001'  , 5    , 2    , 0.5  , 'Qualitätssicherung  Prüfprotokoll  erstellen', 300      , 120      , 1800     , 0         , 1          , 2           );
    ---
    INSERT  INTO  op2( o2_n, o2_ix          , o2_ks    , o2_th, o2_tr, o2_txt   , o2_th_sek, o2_tr_sek, o2_lgz_sek, o2_zeinh_tr, o2_zeinh_tx )
        VALUES       ( 10  , _op_ix_2022A_v1, 'MON-001', 60   , 0.5  , 'Montage', 3600     , 1800     , 0         , 1          , 2           );
    ---
    INSERT  INTO  op2( o2_n, o2_ix          , o2_ks   , o2_th, o2_tn, o2_tr, o2_txt                                        , o2_th_sek, o2_tn_sek, o2_tr_sek, o2_lgz_sek, o2_zeinh_tr, o2_zeinh_tx )
        VALUES       ( 20  , _op_ix_2022A_v1, 'QS-001', 5    , 2    , 0.5  , 'Qualitätssicherung  Prüfprotokoll  erstellen', 300      , 120      , 1800     , 0         , 1          , 2           );
    ---
    INSERT  INTO  op2( o2_n, o2_ix         , o2_ks    , o2_th, o2_tv, o2_txt     , o2_th_sek, o2_lgz_sek, o2_zeinh_tr, o2_zeinh_tx )
        VALUES       ( 10  , _op_ix_2021_v2, 'MON-001', 30   , 10   , 'Demontage', 1800     , 0         , 1          , 2           )
        RETURNING o2_id INTO o2_id_2021_v2;
    ---

    --- stv
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('W.13.N-272.371 /C');
    INSERT  INTO  stv( st_m, st_n               , st_zn      , st_mgc       , st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 2   , 'W.13.N-272.371 /C', _ak_nr_2021, _artmgc__m_id, 10    , false   , 2  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('W.13.N-272.371 /C');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_txt, st_m_fix, st_m_uf1  )
        VALUES       ( 3, 'W.13.N-272.371 /C', _ak_nr_2021, _artmgc__m_id, 15, 'ABK  zusammenfassen', false, 3  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('Z-21435000-L-Z64');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 6, 'Z-21435000-L-Z64', _ak_nr_2021, _artmgc__m_id, 20, false, 6  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('S.W.13.1100001');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'S.W.13.1100001', _ak_nr_2021, _artmgc__m_id, 30, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0101 /A');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1, st_kstv_st_id  )
        VALUES       ( 1, 'E.B.PKW.A-1168534-0101 /A', _ak_nr_2021, _artmgc__m_id, 90, false, 10000, 11  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('G.PKW.MON-BC.A-1168534 /A');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'G.PKW.MON-BC.A-1168534 /A', _ak_nr_2021, _artmgc__m_id, 100, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('CT-SN350L-TOP8');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'CT-SN350L-TOP8', _ak_nr_2021, _artmgc__m_id, 110, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('W.13.N-272.371 /C');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 2, 'W.13.N-272.371 /C', _ak_nr_2022A, _artmgc__m_id, 10, false, 2  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('W.13.N-272.371 /C');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_txt, st_m_fix, st_m_uf1  )
        VALUES       ( 3, 'W.13.N-272.371 /C', _ak_nr_2022A, _artmgc__m_id, 15, 'ABK  zusammenfassen', false, 3  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('Z-21435000-L-Z64');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 6, 'Z-21435000-L-Z64', _ak_nr_2022A, _artmgc__m_id, 20, false, 6  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('S.W.13.1100001');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'S.W.13.1100001', _ak_nr_2022A, _artmgc__m_id, 30, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0101 /A');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1, st_kstv_st_id  )
        VALUES       ( 1, 'E.B.PKW.A-1168534-0101 /A', _ak_nr_2022A, _artmgc__m_id, 90, false, 10000, 11  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('G.PKW.MON-BC.A-1168534 /A');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'G.PKW.MON-BC.A-1168534 /A', _ak_nr_2022A, _artmgc__m_id, 100, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('CT-SN350L-TOP8');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'CT-SN350L-TOP8', _ak_nr_2022A, _artmgc__m_id, 110, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100002');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'D.W.13.1100002', _ak_nr_2022A, _artmgc__m_id, 120, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('W.13.N-272.371 /C');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 2, 'W.13.N-272.371 /C', _ak_nr_2022B, _artmgc__m_id, 10, false, 2  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('W.13.N-272.371 /C');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_txt, st_m_fix, st_m_uf1  )
        VALUES       ( 3, 'W.13.N-272.371 /C', _ak_nr_2022B, _artmgc__m_id, 15, 'ABK  zusammenfassen', false, 3  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('Z-21435000-L-Z64');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 6, 'Z-21435000-L-Z64', _ak_nr_2022B, _artmgc__m_id, 20, false, 6  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0101 /A');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1, st_kstv_st_id  )
        VALUES       ( 1, 'E.B.PKW.A-1168534-0101 /A', _ak_nr_2022B, _artmgc__m_id, 90, false, 10000, 11  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('G.PKW.MON-BC.A-1168534 /A');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'G.PKW.MON-BC.A-1168534 /A', _ak_nr_2022B, _artmgc__m_id, 100, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('CT-SN350L-TOP8');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'CT-SN350L-TOP8', _ak_nr_2022B, _artmgc__m_id, 110, false, 10000  );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100003');
    INSERT  INTO  stv( st_m, st_n, st_zn, st_mgc, st_pos, st_m_fix, st_m_uf1  )
        VALUES       ( 1, 'D.W.13.1100003', _ak_nr_2022B, _artmgc__m_id, 120, false, 10000  );
    ---

    --- lagerorte
    INSERT  INTO  lagerorte( lgo_web, lgo_desc                  , lgo_name, lgo_sperr, lgo_werthg, lgo_pflicht, lgo_beistell, lgo_nodelete, lgo_verfgbar, lgo_pflichtfrei  )
        SELECT               false  , 'Kunden  Beistelllagerort', 'BELO'  , false    , false     , false      , true        , true        , false       , false
        WHERE NOT EXISTS(SELECT true FROM lagerorte WHERE lgo_name = 'BELO');
    --- ********************

    --- ***** Flussdaten *****
    ---
    INSERT INTO wendat ( w_aknr, w_l_krz, w_lgort, w_lagort, w_lgchnr, w_zugang, w_zug_dat, w_zug_mec, w_akvkpbas, w_rech_eing, w_zugang_uf1, w_preis_inlief, w_adpreis_berech )
      VALUES           ( _ak_nr_2021, 'AUTO-AG', 'BELO', 'BELO', 'QAB: ' || _q_nr_ak_nr_2021_1, 1, current_date, _ak_standard_mgc_2021, 1559.3949, true, 1, false, false )
      RETURNING w_wen INTO _w_wen_ak_nr_2021_1;
    ---
    INSERT INTO wendat ( w_aknr, w_l_krz, w_lgort, w_lagort, w_lgchnr, w_zugang, w_zug_dat, w_zug_mec, w_akvkpbas, w_rech_eing, w_zugang_uf1, w_preis_inlief, w_adpreis_berech )
      VALUES           ( _ak_nr_2021, 'AUTO-AG', 'BELO', 'BELO', 'QAB: ' || _q_nr_ak_nr_2021_2, 1, current_date, _ak_standard_mgc_2021, 1559.3949, true, 1, false, false )
      RETURNING w_wen INTO _w_wen_ak_nr_2021_2;
    ---
    INSERT INTO wendat ( w_aknr, w_l_krz, w_lgort, w_lagort, w_lgchnr, w_zugang, w_zug_dat, w_zug_mec, w_akvkpbas, w_rech_eing, w_zugang_uf1, w_preis_inlief, w_adpreis_berech )
      VALUES           ( _ak_nr_2021, 'AUTO-AG', 'BELO', 'BELO', 'QAB: ' || _q_nr_ak_nr_2021_3, 1, current_date, _ak_standard_mgc_2021, 1559.3949, true, 1, false, false )
      RETURNING w_wen INTO _w_wen_ak_nr_2021_3;
    ---

    --- QABs inkl. Lagerzugang
    INSERT  INTO  qab( q_nr              , q_api, q_dat       , q_def, q_stk, q_txt                               , q_typ, q_done, q_ak_nr    , q_sernr             , q_w_wen            , q_mecode, q_festext, q_wirksam, q_reklamok, q_ispreport, q_isservice, q_rech_sperre, q_reklamnotok, q_stk_fehlerhaft )
        VALUES       ( _q_nr_ak_nr_2021_1, 'DEMO', current_date, true , 1    , 'Getriebe  soll  demontiert  werden', 2    , false , _ak_nr_2021, 'GETR_PKW_2021_0001', _w_wen_ak_nr_2021_1, 1       , true     , false    , false     , false      , false      , false        , false        , 1                );
    ---
    INSERT  INTO  qab( q_nr              , q_api, q_dat       , q_def, q_stk, q_txt                                                    , q_typ, q_done, q_ak_nr    , q_sernr             , q_w_wen            , q_mecode, q_festext, q_wirksam, q_reklamok, q_ispreport, q_isservice, q_rech_sperre, q_reklamnotok, q_stk_fehlerhaft )
        VALUES       ( _q_nr_ak_nr_2021_2, 'DEMO', current_date, false, 1    , 'Getriebe  soll  Upgrade  auf  Revision  2022a  erhalten', 2    , false , _ak_nr_2021, 'GETR_PKW_2021_0002', _w_wen_ak_nr_2021_2, 1       , true     , false    , false     , false      , false      , false        , false        , 1                );
    ---
    INSERT  INTO  qab( q_nr              , q_api, q_dat       , q_def, q_stk, q_txt                                                  , q_typ, q_done, q_ak_nr    , q_sernr             , q_w_wen            , q_mecode, q_festext, q_wirksam, q_reklamok, q_ispreport, q_isservice, q_rech_sperre, q_reklamnotok, q_stk_fehlerhaft )
        VALUES       ( _q_nr_ak_nr_2021_3, 'DEMO', current_date, false, 1    , 'Getriebe  soll  Umbau  auf  Revision  2022b  erhalten', 2    , false , _ak_nr_2021, 'GETR_PKW_2021_0003', _w_wen_ak_nr_2021_3, 1       , true     , false    , false     , false      , false      , false        , false        , 1                );
    ---

    UPDATE wendat SET w_q_nr = _q_nr_ak_nr_2021_1 WHERE w_wen = _w_wen_ak_nr_2021_1;
    UPDATE wendat SET w_q_nr = _q_nr_ak_nr_2021_2 WHERE w_wen = _w_wen_ak_nr_2021_2;
    UPDATE wendat SET w_q_nr = _q_nr_ak_nr_2021_3 WHERE w_wen = _w_wen_ak_nr_2021_3;
    ---

    UPDATE lagsernr SET lgs_sernr = 'GETR_PKW_2021_0001' WHERE lgs_w_wen = _w_wen_ak_nr_2021_1;
    UPDATE lagsernr SET lgs_sernr = 'GETR_PKW_2021_0002' WHERE lgs_w_wen = _w_wen_ak_nr_2021_2;
    UPDATE lagsernr SET lgs_sernr = 'GETR_PKW_2021_0003' WHERE lgs_w_wen = _w_wen_ak_nr_2021_3;
    ---

    --- ldsdok
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_ak_nr_2021);
    INSERT INTO ldsdok (ld_ep, ld_kn, ld_abk, ld_mce        , ld_pos, ld_stk, ld_aknr    , ld_arab, ld_code, ld_done, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term          , ld_auftg    , ld_datum    , ld_eklos, ld_sperr, ld_terml         , ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 0   , '#'  , '10042', _artmgc__m_id, 10    , 1     , _ak_nr_2021, 0      , 'I'    , true   , '#'    , '#'    , 1      , 'DM'   , 0      , 0      , current_date + 15, 'DM22-00101', current_date, 1       , false   , current_date + 15, 0        , false    , 'DEMO'     , true      , 1         , 0             , false       , false           , 0            , false          , 1              , 0               , 0                , 0 )
      RETURNING ld_id INTO ld_id_1;
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('W.13.N-272.371 /C');
    INSERT INTO ldsdok (ld_ep , ld_kn, ld_mce       , ld_pos, ld_stk, ld_aknr            , ld_arab, ld_code, ld_done, ld_hpos, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term, ld_auftg, ld_datum, ld_eklos, ld_netto, ld_preis, ld_sperr, ld_terml, ld_brutto, ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_aknr_idx, ld_ep_netto, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 12.55, '#'  , _artmgc__m_id, 20    , 5     , 'W.13.N-272.371 /C', 0      , 'I'    , true   , 10     , '#'    , '#'    , 1      , 'DM'   , 0      , 0      , current_date + 15, 'DM22-00101', current_date, 1, 62.75, 12.55, false, current_date + 15, 62.75, 12.55, false, 'DEMO', false, 5, 'Rev. 95/0002', 12.55, 0, false, false, 12.55, false, 1, 62.75, 62.75, 12.55 );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('Z-21435000-L-Z64');
    INSERT INTO ldsdok (ld_ep , ld_kn, ld_mce       , ld_pos, ld_stk, ld_aknr           , ld_arab, ld_code, ld_done, ld_hpos, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term, ld_auftg, ld_datum, ld_eklos, ld_netto, ld_preis, ld_sperr, ld_terml, ld_brutto, ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_ep_netto, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 70.67, '#'  , _artmgc__m_id, 30    , 6     , 'Z-21435000-L-Z64', 0      , 'I'    , true   , 10     , '#'    , '#'    , 1      , 'DM'   , 0      , 0      , current_date + 15, 'DM22-00101', current_date, 1, 424.02, 70.67, false, current_date + 15, 424.02, 70.67, false, 'DEMO', false, 6, 70.67, 0, false, false, 70.67, false, 1, 424.02, 424.02, 70.67 );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('S.W.13.1100001');
    INSERT INTO ldsdok (ld_ep, ld_kn, ld_mce       , ld_pos, ld_stk, ld_aknr         , ld_arab, ld_code, ld_done, ld_hpos, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term, ld_auftg, ld_datum, ld_eklos, ld_sperr, ld_terml, ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 0   , '#'  , _artmgc__m_id, 40    , 1     , 'S.W.13.1100001', 0      , 'I'    , true   , 10     , '#'    , '#'    , 1      , 'DM'   , 0      , 0      , current_date + 15, 'DM22-00101', current_date, 1, false, current_date + 15, 0, false, 'DEMO', false, 1, 0, false, false, 0, false, 1, 0, 0, 0 );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('E.B.PKW.A-1168534-0101 /A');
    INSERT INTO ldsdok (ld_ep, ld_kn, ld_mce, ld_pos, ld_stk, ld_aknr, ld_arab, ld_code, ld_done, ld_hpos, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term, ld_auftg, ld_datum, ld_eklos, ld_sperr, ld_terml, ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 0   , '#'  , _artmgc__m_id, 50, 1, 'E.B.PKW.A-1168534-0101 /A', 0, 'I', true, 10, '#', '#', 1, 'DM', 0, 0, current_date + 15, 'DM22-00101', current_date, 1, false, current_date + 15, 0, false, 'DEMO', false, 1, 0, false, false, 0, false, 1, 0, 0, 0 );
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('G.PKW.MON-BC.A-1168534 /A');
    INSERT INTO ldsdok (ld_ep, ld_kn, ld_mce, ld_pos, ld_stk, ld_aknr, ld_arab, ld_code, ld_done, ld_hpos, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term, ld_auftg, ld_datum, ld_eklos, ld_sperr, ld_terml, ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 0   , '#'  , _artmgc__m_id, 60, 1, 'G.PKW.MON-BC.A-1168534 /A', 0, 'I', true, 10, '#', '#', 1, 'DM', 0, 0, current_date + 15, 'DM22-00101', current_date, 1, false, current_date + 15, 0, false, 'DEMO', false, 1, 0, false, false, 0, false, 1, 0, 0, 0 );
    ---

    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_ak_nr_2022A);
    INSERT INTO ldsdok (ld_ep, ld_kn, ld_mce, ld_pos, ld_stk, ld_aknr, ld_arab, ld_code, ld_done, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term, ld_auftg, ld_datum, ld_eklos, ld_sperr, ld_terml, ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 0   , '#'  , _artmgc__m_id, 10, 1, _ak_nr_2022A, 0, 'I', true, '#', '#', 1, 'UG', 0, 0, current_date + 15, 'DM22-00102', current_date, 1, false, current_date + 15, 0, false, 'DEMO', false, 1, 0, false, false, 0, false, 1, 0, 0, 0 )
      RETURNING ld_id INTO ld_id_2;
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_ak_nr_2022B);
    INSERT INTO ldsdok (ld_ep, ld_kn, ld_mce, ld_pos, ld_stk, ld_aknr, ld_arab, ld_code, ld_done, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term, ld_auftg, ld_datum, ld_eklos, ld_sperr, ld_terml, ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 0   , '#'  , _artmgc__m_id, 10, 1, _ak_nr_2022B, 0, 'I', true, '#', '#', 1, 'UB', 0, 0, current_date + 15, 'DM22-00103', current_date, 1, false, current_date + 15, 0, false, 'DEMO', false, 1, 0, false, false, 0, false, 1, 0, 0, 0 )
      RETURNING ld_id INTO ld_id_3;
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100002');
    INSERT INTO ldsdok (ld_ep, ld_kn, ld_mce       , ld_pos, ld_stk, ld_aknr, ld_arab, ld_code, ld_done, ld_hpos, ld_krzf, ld_krzl, ld_kurs, ld_stat, ld_stkf, ld_stkl, ld_term, ld_auftg, ld_datum, ld_eklos, ld_sperr, ld_terml, ld_ep_uf1, ld_storno, ld_kontakt, ld_nbedarf, ld_stk_uf1, ld_steuproz, ld_ltastatus, ld_rech_eing, ld_ep_basis_w, ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 0   , '#'  , _artmgc__m_id, 20, 1, 'D.W.13.1100002', 0, 'I', true, 10, '#', '#', 1, 'UB', 0, 0, current_date + 15, 'DM22-00103', current_date, 1, false, current_date + 15, 0, false, 'DEMO', false, 1, 0, false, false, 0, false, 1, 0, 0, 0 );
    ---

    ---
    INSERT INTO abk ( ab_at            , ab_et            , ab_buch, ab_done, ab_stat, ab_ap_nr   , ab_askix      , ab_ld_id, ab_print, ab_sperr, ab_nk_agk, ab_nk_fgk, ab_nk_mgk, ab_nk_rgk, ab_st_uf1, ab_storno, ab_dolager, ab_rckmeld, ab_erstfert, ab_keyvalue , ab_doeinkauf, ab_inplantaf, ab_matchange, ab_nk_change, ab_nk_st_uf1, ab_auftgi_kdatum , ab_displaycaption )
      VALUES        ( current_date + 15, current_date + 15, false  , true   , 'DM'   , _ak_nr_2021, _op_ix_2021_v2, ld_id_1 , false   , false   , 15       , 0        , 0        , 0        , 1        , false    , true      , false     , true       , 'DM22-00101', true        , true        , false       , true        , 1           , current_date + 15, 'I || DM22-00101 || 10' )
      RETURNING ab_ix INTO ab_ix_1;
    ---
    INSERT INTO abk ( ab_at            , ab_et            , ab_buch, ab_done, ab_stat, ab_ap_nr    , ab_askix       , ab_ld_id, ab_print, ab_sperr, ab_nk_agk, ab_nk_fgk, ab_nk_mgk, ab_nk_rgk, ab_st_uf1, ab_storno, ab_dolager, ab_rckmeld, ab_erstfert, ab_keyvalue , ab_doeinkauf, ab_inplantaf, ab_matchange, ab_nk_change, ab_nk_st_uf1, ab_auftgi_kdatum , ab_displaycaption )
      VALUES        ( current_date + 15, current_date + 15, false  , true   , 'UG'   , _ak_nr_2022A, _op_ix_2022A_v2, ld_id_2 , false   , false   , 15       , 0        , 0        , 0        , 1        , false    , true      , false     , true     , 'DM22-00102', true        , true        , false       , true        , 1           , current_date + 15, 'I || DM22-00102 || 10' )
      RETURNING ab_ix INTO ab_ix_2;
    ---
    INSERT INTO abk ( ab_at            , ab_et            , ab_buch, ab_done, ab_stat, ab_ap_nr    , ab_askix       , ab_ld_id, ab_print, ab_sperr, ab_nk_agk, ab_nk_fgk, ab_nk_mgk, ab_nk_rgk, ab_st_uf1, ab_storno, ab_dolager, ab_rckmeld, ab_erstfert, ab_keyvalue , ab_doeinkauf, ab_inplantaf, ab_matchange, ab_nk_change, ab_nk_st_uf1, ab_auftgi_kdatum , ab_displaycaption )
      VALUES        ( current_date + 15, current_date + 15, false  , true   , 'UB'   , _ak_nr_2022B, _op_ix_2022B_v2, ld_id_3 , false   , false   , 15       , 0        , 0        , 0        , 1        , false    , true      , false     , true       , 'DM22-00103', true        , true        , false       , true        , 1           , current_date + 15, 'I || DM22-00103 || 10' )
      RETURNING ab_ix INTO ab_ix_3;
    ---
    ---
    INSERT INTO ab2 ( a2_n, a2_at       , a2_et       , a2_ks    , a2_ta, a2_th, a2_tv, a2_txt     , a2_ausw, a2_buch, a2_ende, a2_prio, a2_ab_ix, a2_o2_id     , a2_sperr, a2_interm, a2_th_sek, a2_awpreis, a2_rckmeld, a2_subject , a2_zeinh_tr, a2_zeinh_tx, a2_auswpruef, a2_time_stemp, a2_time_stemp__ruest_overlap )
      VALUES        ( 10  , current_date, current_date, 'MON-001', 0.55 , 30   , 10   , 'Demontage', false  , false  , true   , 1      , ab_ix_1 , o2_id_2021_v2, false   , true     , 1800     , 0         , false     , 'Demontage', 1          , 2          , false       , 0            , 0 );
    ---
    INSERT INTO ab2 ( a2_n, a2_at       , a2_et       , a2_ks    , a2_ta   , a2_th, a2_tv, a2_txt           , a2_ausw, a2_buch, a2_ende, a2_prio, a2_ab_ix, a2_o2_id      , a2_sperr, a2_interm, a2_th_sek, a2_awpreis, a2_rckmeld, a2_subject       , a2_zeinh_tr, a2_zeinh_tx, a2_auswpruef, a2_time_stemp, a2_time_stemp__ruest_overlap )
      VALUES        ( 10  , current_date, current_date, 'MON-001', 0.183333, 10   , 10   , 'Einbau Dichtung', false  , false  , true   , 1      , ab_ix_2 , o2_id_2022A_v2, false   , true     , 600      , 0         , false     , 'Einbau Dichtung', 1          , 2          , false       , 0            , 0 );
    ---
    INSERT INTO ab2 ( a2_n, a2_at       , a2_et       , a2_ks    , a2_ta   , a2_th, a2_tv, a2_txt                            , a2_ausw, a2_buch, a2_ende, a2_prio, a2_ab_ix, a2_o2_id      , a2_sperr, a2_interm, a2_th_sek, a2_awpreis, a2_rckmeld, a2_subject                            , a2_zeinh_tr, a2_zeinh_tx, a2_auswpruef, a2_time_stemp, a2_time_stemp__ruest_overlap )
      VALUES        ( 10  , current_date, current_date, 'MON-001', 0.366667, 20   , 10   , 'Ausbau Dichtsatz Einbau Dichtung', false  , false  , true   , 1      , ab_ix_3 , o2_id_2022B_v2, false   , true     , 1200     , 0         , false     , E'Ausbau Dichtsatz \n Einbau Dichtung', 1          , '2'        , false       , 0            , 0 );
    ---

    UPDATE ldsdok SET ld_abk = ab_ix_2 WHERE ld_id = ld_id_2;
    UPDATE ldsdok SET ld_abk = ab_ix_3 WHERE ld_id = ld_id_3;

    ---
    INSERT INTO wendat ( w_aknr      , w_ab_ix, w_l_krz, w_lgort, w_lagort, w_lds_id, w_lgchnr, w_zugang, w_zug_dat   , w_zug_mec             , w_akvkpbas, w_menge_ok, w_rech_eing, w_zugang_uf1, w_preis_inlief, w_adpreis_berech )
      VALUES           ( _ak_nr_2022A, ab_ix_2, '#'    , 'ZL'   , 'ZL'    , ld_id_2 , '001'   , 1       , current_date, _ak_standard_mgc_2022A, 1559.3949 , true      , true       , 1           , false         , 'false' )
      RETURNING w_wen INTO _w_wen_ak_nr_2022A;
    ---
    INSERT INTO wendat ( w_aknr      , w_ab_ix, w_l_krz, w_lgort, w_lagort, w_lds_id, w_lgchnr, w_zugang, w_zug_dat   , w_zug_mec             , w_akvkpbas, w_menge_ok, w_rech_eing, w_zugang_uf1, w_preis_inlief, w_adpreis_berech )
      VALUES           ( _ak_nr_2022B, ab_ix_3, '#'    , 'ZL'   , 'ZL'    , ld_id_3 , '002'   , 1       , current_date, _ak_standard_mgc_2022B, 1559.3949 , true      , true       , 1           , false         , false )
      RETURNING w_wen INTO _w_wen_ak_nr_2022B;
    ---

    SELECT lg_id INTO lg_id_ZL_2022A FROM lag WHERE lg_aknr = _ak_nr_2022A AND lg_w_wen = _w_wen_ak_nr_2022A;
    IF lg_id_ZL_2022A IS null THEN
        INSERT INTO lag ( lg_mce                , lg_ort, lg_aknr     , lg_chnr, lg_ld_id, lg_sperr, lg_w_wen          , lg_anztot, lg_lagzudat )
          VALUES        ( _ak_standard_mgc_2022A, 'ZL'  , _ak_nr_2022A, '001'  , ld_id_2 , false   , _w_wen_ak_nr_2022A, 1        , current_date )
          RETURNING lg_id INTO lg_id_ZL_2022A;
    END IF;

    ---
    SELECT lg_id INTO lg_id_ZL_2022B FROM lag WHERE lg_aknr = _ak_nr_2022B AND lg_w_wen = _w_wen_ak_nr_2022B;
    IF lg_id_ZL_2022B IS null THEN
        INSERT INTO lag ( lg_mce                , lg_ort, lg_aknr     , lg_chnr, lg_ld_id, lg_sperr, lg_w_wen          , lg_anztot, lg_lagzudat )
          VALUES        ( _ak_standard_mgc_2022B, 'ZL'  , _ak_nr_2022B, '002'  , ld_id_3 , false   , _w_wen_ak_nr_2022B, 1        , current_date )
          RETURNING lg_id INTO lg_id_ZL_2022B;
    END IF;
    ---

    UPDATE lagsernr SET lgs_sernr = 'GETR_PKW_2021_0002_Upgrade_2022a' WHERE lgs_w_wen = _w_wen_ak_nr_2022A;
    UPDATE lagsernr SET lgs_sernr = 'GETR_PKW_2021_0003_Umbau_2022b'   WHERE lgs_w_wen = _w_wen_ak_nr_2022B;
    ---

    ---
    INSERT INTO auftg ( ag_nr , ag_lkn, ag_mcv               , ag_pos, ag_stk, ag_vkp, ag_aknr    , ag_arab, ag_bdat     , ag_done, ag_hest, ag_krzf, ag_krzl, ag_kukl, ag_kurs, ag_prkl, ag_stat, ag_stkb, ag_stkf, ag_stkl, ag_astat, ag_datum    , ag_post2, ag_post3, ag_post6, ag_sperr, ag_kdatum      , ag_storno, ag_vkpbas, ag_aldatum      , ag_kontakt, ag_mainabk, ag_nbedarf, ag_stk_uf1, ag_vkp_uf1, ag_canrabatt, ag_parentabk, ag_nstatistik, ag_stkres_uf1, ag_vkp_basis_w, ag_vkptotalpos, ag_preiseinheit, ag_vkp_uf1_basis_w )
      VALUES          ( _ag_nr, '#'   , _ak_standard_mgc_2021, 10    , 1     , 0     , _ak_nr_2021, 0      , current_date, true   , 0      , '#'    , '#'    , 0      , 1      , 0      , 'DM'   , 0      , 0      , 0      , 'I'     , current_date, 'M'     , ab_ix_1 , ab_ix_1 , false   , current_date + 7, false   , 1559.3949, current_date + 7, 'DEMO'     , ab_ix_1   , false     , 1         , 0         , true        , ab_ix_1     , false        , 0            , 0             , false         , 1              , 0 )
      RETURNING ag_id INTO _ag_id_pos_10;
    ---
    INSERT INTO auftg ( ag_nr , ag_lkn, ag_mcv               , ag_pos, ag_stk, ag_vkp, ag_aknr    , ag_arab, ag_bdat     , ag_done, ag_hest, ag_krzf, ag_krzl, ag_kukl, ag_kurs, ag_prkl, ag_stat, ag_stkb, ag_stkf, ag_stkl, ag_astat, ag_datum    , ag_post2, ag_post3, ag_post6, ag_sperr, ag_kdatum       , ag_storno, ag_vkpbas, ag_aldatum      , ag_kontakt, ag_mainabk, ag_nbedarf, ag_stk_uf1, ag_vkp_uf1, ag_canrabatt, ag_parentabk, ag_nstatistik, ag_stkres_uf1, ag_vkp_basis_w, ag_vkptotalpos, ag_preiseinheit, ag_vkp_uf1_basis_w )
      VALUES          ( _ag_nr, '#'   , _ak_standard_mgc_2021, 20    , 1     , 0     , _ak_nr_2021, 0      , current_date, true   , 0      , '#'    , '#'    , 0      , 1      , 0      , 'UG'   , 0      , 0      , 0      , 'I'     , current_date, 'M'     , ab_ix_2 , ab_ix_2 , false   , current_date + 7, false    , 1559.3949, current_date + 7, 'DEMO'     , ab_ix_2   , false     , 1         , 0         , true        , ab_ix_2     , false        , 0            , 0             , false         , 1              , 0 )
      RETURNING ag_id INTO _ag_id_pos_20;
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100002');
    INSERT INTO auftg ( ag_nr , ag_lkn, ag_mcv       , ag_pos, ag_stk, ag_vkp, ag_aknr         , ag_arab, ag_bdat     , ag_done, ag_hest, ag_krzf, ag_krzl, ag_kukl, ag_kurs, ag_prkl, ag_stkb, ag_stkf, ag_stkl, ag_astat, ag_datum    , ag_post2, ag_post3, ag_post6, ag_sperr, ag_kdatum       , ag_storno, ag_aldatum      , ag_kontakt, ag_mainabk, ag_nbedarf, ag_stk_uf1, ag_vkp_uf1, ag_canrabatt, ag_parentabk, ag_nstatistik, ag_stkres_uf1, ag_vkp_basis_w, ag_vkptotalpos, ag_preiseinheit, ag_vkp_uf1_basis_w )
      VALUES          ( _ag_nr, '#'   , _artmgc__m_id, 30    , 1     , 0     , 'D.W.13.1100002', 0      , current_date, false  , 0      , '#'    , '#'    , 0      , 1      , 0      , 0      , 0      , 0      , 'I'     , current_date, 'N'     , ab_ix_2 , ab_ix_2 , false   , current_date + 7, false    , current_date + 7, 'DEMO'     , ab_ix_2   , false     , 1         , 0         , true        , ab_ix_2     , false        , 0            , 0             , false         , 1              , 0 )
      RETURNING ag_id INTO _ag_id_pos_30;
    ---
    INSERT INTO auftg ( ag_nr , ag_lkn, ag_mcv               , ag_pos, ag_stk, ag_vkp, ag_aknr    , ag_arab, ag_bdat     , ag_done, ag_hest, ag_krzf, ag_krzl, ag_kukl, ag_kurs, ag_prkl, ag_stat, ag_stkb, ag_stkf, ag_stkl, ag_astat, ag_datum    , ag_post2, ag_post3, ag_post6, ag_sperr, ag_kdatum       , ag_storno, ag_vkpbas, ag_aldatum      , ag_kontakt, ag_mainabk, ag_nbedarf, ag_stk_uf1, ag_vkp_uf1, ag_canrabatt, ag_parentabk, ag_nstatistik, ag_stkres_uf1, ag_vkp_basis_w, ag_vkptotalpos, ag_preiseinheit, ag_vkp_uf1_basis_w )
      VALUES          ( _ag_nr, '#'   , _ak_standard_mgc_2021, 40    , 1     , 0     , _ak_nr_2021, 0      , current_date, true   , 0      , '#'    , '#'    , 0      , 1      , 0      , 'UB    ', 0     , 0      , 0      , 'I'     , current_date, 'M'     , ab_ix_3 , ab_ix_3 , false   , current_date + 7, false    , 1559.3949, current_date + 7, 'DEMO'     , ab_ix_3   , false     , 1         , 0         , true        , ab_ix_3     , false        , 0            , 0             , false         , 1              , 0 )
      RETURNING ag_id INTO _ag_id_pos_40;
    ---
    _artmgc__m_id := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('D.W.13.1100003');
    INSERT INTO auftg ( ag_nr , ag_lkn, ag_mcv       , ag_pos, ag_stk, ag_vkp, ag_aknr         , ag_arab, ag_bdat     , ag_done, ag_hest, ag_krzf, ag_krzl, ag_kukl, ag_kurs, ag_prkl, ag_stkb, ag_stkf, ag_stkl, ag_astat, ag_datum    , ag_post2, ag_post3, ag_post6, ag_sperr, ag_kdatum       , ag_storno, ag_aldatum      , ag_kontakt, ag_mainabk, ag_nbedarf, ag_stk_uf1, ag_vkp_uf1, ag_canrabatt, ag_parentabk, ag_nstatistik, ag_stkres_uf1, ag_vkp_basis_w, ag_vkptotalpos, ag_preiseinheit, ag_vkp_uf1_basis_w )
      VALUES          ( _ag_nr, '#'   , _artmgc__m_id, 50    , 1     , 0     , 'D.W.13.1100003', 0      , current_date, false  , 0      , '#'    , '#'    , 0      , 1      , 0      , 0      , 0      , 0      , 'I'     , current_date, 'N'     , ab_ix_3 , ab_ix_3 , false   , current_date + 7, false    , current_date + 7, 'DEMO'     , ab_ix_3   , false     , 1         , 0         , true        , ab_ix_3     , false        , 0            , 0             , false         , 1              , 0 )
      RETURNING ag_id INTO _ag_id_pos_50;
    ---

    INSERT INTO lifsch ( l_krz, l_abgg, l_aknr     , l_arab, l_krzf, l_krzl, l_ldat      , l_ab_ix, l_ag_id      , l_azutx, l_lgort, l_w_wen            , l_dofakt, l_lgchnr      , l_abg_mec            , l_vkp_uf1, l_abgg_uf1 )
      VALUES           ( '#'  , 1     , _ak_nr_2021, 0     , '#'   , '#'   , current_date, ab_ix_1, _ag_id_pos_10, ''     , 'BELO' , _w_wen_ak_nr_2021_1, false   , 'QAB: ' || _q_nr_ak_nr_2021_1, _ak_standard_mgc_2021, 0        , 1          )
      RETURNING l_nr INTO _l_nr_ak_nr_2021_1;

    ---
    INSERT INTO lifsch ( l_krz, l_abgg, l_aknr     , l_arab, l_krzf, l_krzl, l_ldat      , l_ab_ix, l_ag_id, l_azutx, l_lgort, l_w_wen            , l_dofakt, l_lgchnr      , l_abg_mec            , l_vkp_uf1, l_abgg_uf1 )
      VALUES           ( '#'  , 1     , _ak_nr_2021, 0     , '#'   , '#'   , current_date, ab_ix_2, _ag_id_pos_20    , ''     , 'BELO' , _w_wen_ak_nr_2021_2, false   , 'QAB: ' || _q_nr_ak_nr_2021_2, _ak_standard_mgc_2021, 0        , 1          )
      RETURNING l_nr INTO _l_nr_ak_nr_2021_2;
    ---
    INSERT INTO lifsch ( l_krz, l_abgg, l_aknr     , l_arab, l_krzf, l_krzl, l_ldat      , l_ab_ix, l_ag_id, l_azutx, l_lgort, l_w_wen            , l_dofakt, l_lgchnr      , l_abg_mec            , l_vkp_uf1, l_abgg_uf1 )
      VALUES           ( '#'  , 1     , _ak_nr_2021, 0     , '#'   , '#'   , current_date, ab_ix_3, _ag_id_pos_40    , ''     , 'BELO' , _w_wen_ak_nr_2021_3, false   , 'QAB: ' || _q_nr_ak_nr_2021_3, _ak_standard_mgc_2021, 0        , 1          )
      RETURNING l_nr INTO _l_nr_ak_nr_2021_3;
    ---

    ---
    UPDATE lagsernr SET lgs_l_nr = _l_nr_ak_nr_2021_1 WHERE lgs_w_wen = _w_wen_ak_nr_2021_1;
    UPDATE lagsernr SET lgs_l_nr = _l_nr_ak_nr_2021_2 WHERE lgs_w_wen = _w_wen_ak_nr_2021_2;
    UPDATE lagsernr SET lgs_l_nr = _l_nr_ak_nr_2021_3 WHERE lgs_w_wen = _w_wen_ak_nr_2021_3;
    ---

    ---
    SELECT lgs_id INTO _lgs_id FROM lagsernr WHERE lgs_w_wen = _w_wen_ak_nr_2022A;
    INSERT INTO mapsernr ( ms_lgs_id, ms_table          , ms_pkey )
      VALUES             ( _lgs_id  , 'ldsdok'::REGCLASS, ld_id_2 );
    ---
    SELECT lgs_id INTO _lgs_id FROM lagsernr WHERE lgs_w_wen = _w_wen_ak_nr_2022B;
    INSERT INTO mapsernr ( ms_lgs_id, ms_table          , ms_pkey )
      VALUES             ( _lgs_id  , 'ldsdok'::REGCLASS, ld_id_3 );
    ---

    --- ********************
END $$;

-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;